# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:  # Round 1
        return "C"
    
    if len(my_history) == 9:  # Round 10
        return "D"
    
    # Check if opponent's code is simple (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check if opponent defected repeatedly (3+ times in a row)
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"
    
    # Probabilistic tit-for-tat
    last_opp_move = opp_history[-1]
    if last_opp_move == "C":
        return "C" if random.random() < 0.8 else "D"
    else:
        return "D" if random.random() < 0.8 else "C"